import os
import sys
import subprocess
from distutils import dir_util, file_util

# List of Python module dependencies
DEPS = ["requests", "pefile"]

def proceed(question):
    """
    Do you want to proceed [Y/n]. Returns True if 'yes' and False if 'no'
    """
    valid = ["y"]
        
    while True:
        sys.stdout.write(question)
        choice = input().lower()
        if choice == '':
            return True
        elif choice == 'y':
            return True
        else:
            return False


def runcmd(my_cmd):
    """ 
    Execute shell command
    """

    print("[DDR_INSTALLER][INFO] Executing cmd: \n{}\n".format(my_cmd))

    stdout = False
    stderr = False

    try:
        process = subprocess.run(my_cmd)

        if process.returncode != 0:
            print("\n[DDR_INSTALLER][WARNING] Command execution failed. Error code: {:d}".format(process.returncode))
            ret = False
        else:
            ret = True
                    
    except :
        print("[DDR_INSTALLER][ERROR] Exception: Command execution failed with unknown error.")
        ret = False
    
    return ret

def install_deps(ida_python_path):
    """
    Main installer routine to install all neccessary 
    dependencies for DDR IDA plugin
    """

    ida_python_interpreter = ida_python_path + "\\python.exe"
    ida_python_pip         = ida_python_path + "\\Scripts\\pip.exe"

    # update pip in virtual enviroment
    print("[DDR_INSTALLER][INFO] Updating pip in virtual enviroment.")
    my_cmd = ida_python_interpreter + " -m pip install --no-warn-script-location --upgrade pip" 
    if runcmd(my_cmd):
        print("[DDR_INSTALLER][INFO] pip updated.\n")
    else:
        print("[DDR_INSTALLER][ERROR] Failed to update pip.\n")
        return False

    # Install pip tools
    print("[DDR_INSTALLER][INFO] Installing pip-tools.")
    my_cmd = ida_python_pip + " install --no-warn-script-location --upgrade pip-tools" 
    if runcmd(my_cmd):
        print("[DDR_INSTALLER][INFO] pip tools installed.\n")
    else:
        print("[DDR_INSTALLER][ERROR] Failed to install pip tools.\n")
        return False

    # Install dependencies
    for m in DEPS:
        print("[DDR_INSTALLER][INFO] --- Installing {} ---".format(m))
        my_cmd = ida_python_pip + " install --no-warn-script-location --upgrade " + m 
        if runcmd(my_cmd):
            print("[DDR_INSTALLER][INFO] --- {} installed. ---\n".format(m))
        else:
            print("[DDR_INSTALLER][ERROR] Failed to install {}.\n".format(m))
            return False

# --- Main ---
if __name__ == "__main__":

    ida_install_dir = r"<IDA_INSTALL_DIR>"
    ida_plugin_dir  = r"<IDA_PLUGIN_DIR>"
    ida_python_path = r"<IDA_PYTHON_PATH>"

    print("[DDR_INSTALLER][INFO] Using the following directories:")
    print("[DDR_INSTALLER][INFO] IDA install dir: {}".format(ida_install_dir))
    print("[DDR_INSTALLER][INFO] IDA plugin dir : {}".format(ida_plugin_dir))
    print("[DDR_INSTALLER][INFO] IDA Python dir : {}\n".format(ida_python_path))

    if os.path.isdir(ida_install_dir) == False: 
        print("[DDR_INSTALLER][ERROR] {} is not a directory.".format(ida_install_dir))
        exit(1)
    if os.path.isdir(ida_plugin_dir)  == False:
        print("[DDR_INSTALLER][ERROR] {} is not a directory.".format(ida_plugin_dir))
        exit(1)
    if os.path.isdir(ida_python_path) == False:
        print("[DDR_INSTALLER][ERROR] {} is not a directory.".format(ida_python_path))
        exit(1)

    # Install dependencies
    if proceed("[DDR_INSTALLER][INFO] Should we proceed with installing the Python module dependencies ? [Y/n]"):
        install_deps(ida_python_path)
            
    # Copy DDR files to plugin directory
    if proceed("[DDR_INSTALLER][INFO] Should we proceed with copying the DDR plugin files to the IDA plugin directory? [Y/n]"):
        print("[DDR_INSTALLER][INFO] Copying plugin files to {}...".format(ida_plugin_dir))
        flist = dir_util.copy_tree("ddr", ida_plugin_dir + "\\ddr")  
        for f in flist:
            print("[DDR_INSTALLER][INFO] File: {} copied.".format(f))

        f = file_util.copy_file("ddr_plugin.py", ida_plugin_dir + "\\ddr_plugin.py")
        print("[DDR_INSTALLER][INFO] File: {} copied.".format(f[0]))

        print("\nDone. Go back to the malware machine side and start the DDR server.")
        print("Then start IDA and ... Happy reversing !\n")


