/* Description:
    Detects ELF or MachO tinyshell backdoor on static, dynamic binary form.
    It is commonly used as backdoor in Linux, FreeBSD or MacOSX operating systems.
    This rule by default is NOT designed to scan the CNC client side.
    Category: ELF or MachO, backdoor, hacktool, RAT, shell
   License:
    This Yara ruleset is under the GNU-GPLv2 license (http://www.gnu.org/licenses/gpl-2.0.html)
    Version 1-20180211, author:unixfreaxjp
*/

private rule is__osx
{
 meta:
    date = "2018-02-12"
    author = "@unixfreaxjp"
 condition:
    uint32(0) == 0xfeedface     or uint32(0) == 0xcafebabe
    or uint32(0) == 0xbebafeca  or uint32(0) == 0xcefaedfe
    or uint32(0) == 0xfeedfacf  or uint32(0) == 0xcffaedfe
}

private rule priv01 {
 meta:
    date = "2018-02-11"
    author = "@unixfreaxjp"
 strings:
    $vara01 = { 73 3A 70 3A 00 }
    $vara02 = "Usage: %s" fullword nocase wide ascii
    $vara03 = "[ -s secret ]" fullword nocase wide ascii
    $vara04 = "[ -p port ]" fullword nocase wide ascii
 condition:
    all of them
}

private rule priv03 {
 meta:
    date = "2018-02-10"
    author = "@unixfreaxjp"
 strings:
    $varb01 = { 41 57 41 56 41 55 41 54 55 53 0F B6 06 }
    $varb02 = { 48 C7 07 00 00 00 00 48 C7 47 08 00 00 }
    $vard01 = { 55 48 89 E5 41 57 41 56 41 55 41 54 53 }
    $vard02 = { 55 48 89 E5 48 C7 47 08 00 00 00 00 48 }
    // can be added
 condition:
    (2 of ($varb*)) or (2 of ($vard*))
}

private rule priv04 {
 meta:
    date = "2018-02-11"
    author = "@unixfreaxjp"
 strings:
    $varb03 = { 89 DF E8 FB A4 FF FF 83 C3 01 81 FB 00 04 }
    $vard03 = { 66 89 05 7D 5E 00 00 }
    // can be added
 condition:
    1 of them
}

private rule priv02 {
 meta:
    date = "2018-02-10"
    author = "@unixfreaxjp"
 strings:
    $vare01 = "socket" fullword nocase wide ascii
    $vare02 = "connect" fullword nocase wide ascii
    $vare03 = "alarm" fullword nocase wide ascii
    $vare04 = "dup2" fullword nocase wide ascii
    $vare05 = "execl" fullword nocase wide ascii
    $vare06 = "openpty" fullword nocase wide ascii
    $vare07 = "putenv" fullword nocase wide ascii
    $vare08 = "setsid" fullword nocase wide ascii
    $vare09 = "ttyname" fullword nocase wide ascii
    $vare00 = "waitpid" fullword nocase wide ascii
    $varc01 = "HISTFIL" fullword nocase wide ascii
    $varc02 = "TERML" fullword nocase wide ascii
    $varc03 = "/bin/sh" fullword nocase wide ascii
 condition:
    (5 of ($vare*)
    or (2 of ($varc*)))
}

rule MALW_TinyShell_backconnect_OSX {
 meta:
    date = "2018-02-10"
    author = "@unixfreaxjp"
 condition:
    is__osx
    and priv01
    and priv02
    and priv03
    and priv04
    and filesize < 100KB
}

rule MALW_TinyShell_backconnect_ELF {
 meta:
    date = "2018-02-10"
    author = "@unixfreaxjp"
 condition:
    is__elf
    and priv01
    and ((priv02)
      or ((priv03)
        or (priv04)))
    and filesize < 100KB
}

rule MALW_TinyShell_backconnect_Gen {
 meta:
    date = "2018-02-11"
    author = "@unixfreaxjp"
 condition:
    ((is__elf) or  (is__osx))
    and priv01
    and priv02
    and filesize < 100KB
}

rule MALW_TinyShell_backdoor_Gen {
 meta:
    date = "2018-02-11"
    author = "@unixfreaxjp"
 condition:
    ((is__elf) or  (is__osx))
    and priv01
    and filesize > 20KB
}
