import ida_kernwin
import ida_lines
import ida_funcs
import ida_moves
import ida_name
import ida_ua
import idc

g_wname = "IDA View-A"

def find_widget(wname=g_wname):
    w = ida_kernwin.find_widget(wname)
    if w is None:
        ida_kernwin.open_disasm_window(wname[-1])
        w = ida_kernwin.find_widget(wname)
    return w

def jump_to_func_ptr_line_pos(text, func_name, tweak=0, add_x=False, wname=g_wname):
    flag = False
    idx = text.find(func_name)
    
    w = find_widget(wname)
    if w is None:
        return flag
        
    # we are already at a certain point. but ida sometimes does not point to a function in the middle of the instruction.
    # that's why I use position 0 of x first, and then move to the right position again.
    if idx == 0:
        pos, x, y = ida_kernwin.get_custom_viewer_place(w, 0)
        orig_x = x
        if not add_x:
            orig_x = 0
        ida_kernwin.jumpto(w, pos, 0, y)
        pos, x, y = ida_kernwin.get_custom_viewer_place(w, 0)
        ida_kernwin.jumpto(w, pos, orig_x+tweak, y)
        flag = True
    elif idx > 0:
        pos, x, y = ida_kernwin.get_custom_viewer_place(w, 0)
        if not add_x:
            x = 0
        ida_kernwin.jumpto(w, pos, x+idx+tweak, y)
        flag = True
    return flag

"""
def get_apiname_line(ea, wname=g_wname):
    fn = idc.get_name(ea)
    if not fn:
        return None, None

    fn, line, idx = get_funcname_line(ea)
    if not fn:
        return None, None
        
    w = find_widget(wname)
    if w is None:
        return None, None
    pos, x, y = ida_kernwin.get_custom_viewer_place(w, 0)
    ida_kernwin.jumpto(w, pos, 0, y)
        
    l = ida_kernwin.get_curline()
    if l and l.find(fn) >= 0:
        l_removed = ida_lines.tag_remove(l)
        return fn, l_removed
        
    return None, None
"""

def jump_to_line(ea, i, wname=g_wname):
    w = find_widget(wname)
    if w is None:
        return False
    pos, x, y = ida_kernwin.get_custom_viewer_place(w, 0)
    pos.lnnum = i
    ida_kernwin.jumpto(w, pos, x, y)
    return True

"""
def check_line(ea, i, fn, wname=g_wname):
    w = find_widget(wname)
    if w is None:
        return None, -1
    pos, x, y = ida_kernwin.get_custom_viewer_place(w, 0)
    pos.lnnum = i
    ida_kernwin.jumpto(w, pos, x, y)
    l = ida_kernwin.get_curline()
    l_removed = ida_lines.tag_remove(l)
    l_removed_content = l_removed.split(";")[0]
    idx = l_removed_content.find(fn)
    if idx >= 0:
        return l_removed_content, idx
    return None, -1
"""

def get_func_name_line_no(ea, fn, max_trial):
    _, disass = ida_lines.generate_disassembly(
        ea,
        max_trial,  # maximum number of lines
        False,      # as_stack=False
        True)       # notags
    for i, l in enumerate(disass):
        l_content = l.split(";")[0]
        idx = l_content.find(fn)
        if idx >= 0:
            return l, i, idx
    return "", -1, -1

def get_funcname_line(ea, max_trial=200, wname=g_wname):
    f = ida_funcs.get_func(ea)
    if f:
        func_ea = f.start_ea
        fn = idc.get_func_name(func_ea)
    else:
        fn = ida_name.get_name(ea)
        
    if fn:
        line, i, idx = get_func_name_line_no(ea, fn, max_trial)
        if i < 0:
            return None, None, -1

        jump_to_line(ea, i, wname)
        if jump_to_func_ptr_line_pos(line, fn, wname=wname):
            return fn, line, idx
        
    return None, None, -1

"""
def get_funcname_line(ea, force_trial=True, max_trial=100, wname=g_wname):
    f = ida_funcs.get_func(ea)
    if f:
        func_ea = f.start_ea
        #ida_kernwin.jumpto(func_ea, -1, ida_kernwin.UIJMP_DONTPUSH)
        #ida_kernwin.jumpto(func_ea)
        fn = idc.get_func_name(func_ea)
    else:
        #ida_kernwin.jumpto(ea)
        fn = ida_name.get_name(ea)
        
    if fn:
        w = find_widget(wname)
        if w is None:
            return None, None, -1
        pos, x, y = ida_kernwin.get_custom_viewer_place(w, 0)
        
        lnnum = pos.lnnum
        ida_kernwin.jumpto(w, pos, 0, y)
        i = 0
        for i in range(lnnum):
            print(i)
            line, idx = check_line(ea, i, fn, wname)
            if line is not None:
                return fn, line, idx
        if force_trial and i < max_trial:
            print(i)
            for i in range(i, max_trial):
                line, idx = check_line(ea, i, fn, wname)
                if line is not None:
                    return fn, line, idx
    return None, None, -1
"""

def push_lochist_jump(w):
    r = False
    if w is None:
        return False
    loc = ida_moves.lochist_entry_t()
    r = ida_kernwin.get_custom_viewer_location(loc, w)
    if r:
        loc.renderer_info().pos.cx = 0
        r = ida_kernwin.custom_viewer_jump(w, loc, ida_kernwin.CVNF_JUMP)
    return False

def jumpto_name(ea, wname=g_wname):
    flag = False
    ida_kernwin.jumpto(ea)
    func = ida_funcs.get_func(ea)
    # for callee
    if func:
        fn, line, idx = get_funcname_line(func.start_ea, wname=wname)
        if idx >= 0:
            w = find_widget(wname)
            if w is None:
                return False
            pos, x, y = ida_kernwin.get_custom_viewer_place(w, 0)
            ida_kernwin.jumpto(w, pos, idx, 0)
        flag = True
    # for APIs and strings
    else:
        fn, line, idx = get_funcname_line(ea, wname=wname)
        if fn:
            flag = jump_to_func_ptr_line_pos(line, fn, wname=wname)
    return flag

def jumpto_opn(ea, opn, wname=g_wname):
    flag = False
    if opn >= 0:
        tweak = 0
        #ida_kernwin.jumpto(ea, opn, ida_kernwin.UIJMP_DONTPUSH)
        ida_kernwin.jumpto(ea, opn)
        
        op = idc.print_operand(ea, opn)
        optype = idc.get_operand_type(ea, opn)
        v = idc.get_operand_value(ea, opn)
        f = ida_funcs.get_func(ea)
        func_flags = idc.get_func_attr(ea, idc.FUNCATTR_FLAGS)
        func_name = ida_funcs.get_func_name(ea)
        if func_flags & ida_funcs.FUNC_THUNK:
            func_name = ida_name.get_name(v)
        elif not f:
            func_name = ida_name.get_name(ea)
        fn = ""
        if func_name:
            fn = ida_lines.tag_remove(func_name)
        if optype in [ida_ua.o_displ, ida_ua.o_phrase]:
            # IDA's jumpto API does not point to the first character
            # if an operand starts with "[" like "lea     rax, [rdi+0B0h]".
            # This is a tweak value for it.
            if op and op[0] == '[':
                tweak = -1
            # for an applied structure member
            if op.find(".") >= 0:
                fn = op.rsplit(".", 1)[1]
            # for a stack variable name or a non-applied structure member
            elif op.find("+") >= 0:
                fn = op.rsplit("+", 1)[1]
            elif op.find("[") >= 0:
                fn = op.rsplit("[", 1)[1]
        # for offset
        else:
            fn = ida_name.get_name(v)
            if fn:
                fn = ida_lines.tag_remove(fn)
        if fn:
            flag = jump_to_func_ptr_line_pos(op, fn, tweak, add_x=True, wname=wname)
    return flag

"""
def jumpto_non_func(ea, wname=g_wname):
    flag = False
    flags = ida_bytes.get_flags(ea)
    if idc.is_code(flags):
        # for strings in funcs and other variables in funcs
        insn = ida_ua.insn_t()
        inslen = ida_ua.decode_insn(insn, ea)
        for opn in range(inslen):
            if ida_ua.o_void == insn.ops[opn].type:
                opn = -1
                break
            op = idc.print_operand(ea, opn)
            v = idc.get_operand_value(ea, opn)
            fn = ida_name.get_name(v)
            if fn:
                #ida_kernwin.jumpto(ea, opn, ida_kernwin.UIJMP_DONTPUSH)
                ida_kernwin.jumpto(ea, opn)
                fn = ida_lines.tag_remove(fn)
                flag = jump_to_func_ptr_line_pos(op, fn)
                break
    else:
        # for API names or variable names
        fn, line = get_apiname_line(ea)
        if fn:
            flag = jump_to_func_ptr_line_pos(line, fn)
            
        # for strings with many xrefs
        else:
            fn, line, idx = get_funcname_line(ea)
            if idx > 0:
                w = find_widget(wname)
                if w is None:
                    return False
                pos, x, y = ida_kernwin.get_custom_viewer_place(w, 0)
                ida_kernwin.jumpto(w, pos, idx, y)
                flag = True
    return flag
"""
