import idaapi
import idautils
import idc


def extract_pseudocode(address):
    """
    Extract decompiled pseudocode at the given address.
    """
    f = idaapi.get_func(address)
    if f:
        try:
            cfunc = idaapi.decompile(f)
            pseudocode = cfunc.get_pseudocode()
            lines = []
            for sl in pseudocode:
                lines.append(idaapi.tag_remove(sl.line))
            pseudocode_text = "\n".join(lines)
            return pseudocode_text
        except idaapi.DecompilationFailure:
            return "Failed to decompile the function"
    return "Function not found at address"

def main():
    fn_refs = idc.ARGV[1]
    md_text = ""
    for r in fn_refs.split(','):
        fn_addr = None
        if r[0].isdigit():
            fn_addr = int(r, 16)
        else:
            fn_addr = idc.get_func_addr(r)
        pc_text = extract_pseudocode(fn_addr)
        md_text += "```\n{}\n```\n\n".format(pc_text)

    tf_path = idc.ARGV[2]

    with open(tf_path, "w") as f:
        f.write(md_text)

    idc.qexit(0)


if __name__ == '__main__':
    main()
