import json
#
import pyperclip
#
import ida_hexrays
import idaapi
import idc
#
from utils.ida_utils import update_ui


def set_func_name(loc, val, org, env=None):
    idc.set_name(loc, val, idaapi.SN_CHECK)
    update_ui(loc)

def set_func_vars(loc, val, org, env=None):
    dic = json.loads(val)
    for org, new in dic.items():
        if ida_hexrays.rename_lvar(loc, org, new):
            print("Updated variable: {} -> {}".format(org, new))

def set_func_comment(loc, val, org, env=None):
    idc.set_func_cmt(loc, val, False)
    update_ui(loc)

def set_func_clipboard(loc, val, org, env=None):
    pyperclip.copy(str(val))
