def get_type_def(type_name):
    type_id = idc.get_struc_id(type_name)
    type_size = idc.get_struc_size(type_id)

    struct_def = []
    struct_def.append("{:08X} struct {} // sizeof=0x{:X}".format(0, type_name, type_size))
    struct_def.append("{:08X} {{".format(0))

    for m_offset, m_name, m_size in idautils.StructMembers(type_id):
        m_name_id = idc.get_member_id(type_id, m_offset)
        udm = ida_typeinf.udm_t()
        ida_typeinf.get_udm_by_fullname(udm, idc.get_struc_name(m_name_id))
        m_type = udm.type

        struct_def.append("{:08X}     {} {};".format(m_offset, m_type, m_name))

    struct_def.append("{:08X} }};".format(type_size))
    return "\n".join(struct_def)
