import os
import re
import idaapi


def split_db_fns(s):
    """
    Splits a string into a database path and a list of functions references.
    The input string should be in the format '<db-path>:<references-list>'.
    """
    colon_index = s.rfind(':')

    if colon_index != -1 and colon_index != len(s) - 1:
        path = s[:colon_index]
        list_part = s[colon_index + 1:]
        return path, list_part
    else:
        raise ValueError("Invalid format for function references.")

def validate_map(val):
    return val if ':' in val else None

def validate_map_eq(val):
    return val if any(s in val for s in (':', '=')) else None

def validate_ref_addr(val):
    return val if val[0].isdigit() else None

def validate_ref_idb(val):
    if ':' in val and any(s in val for s in ('.idb', '.i64')):
        db_path, fn_addr = split_db_fns(val)
        if os.path.exists(db_path):
            return val
    return None


if __name__ == "__main__":
    pass
