import collections
import json
import os
import re
import sys
import time
#
import idc
import idaapi
import idautils
#
from shims import ida_shims
from utils import plg_utils
from ui import qt_widgets
from ui.ui_idaxlm import Ui_PluginDialog
from shims.qt_shims import (
    QColor,
    QCoreApplication,
    QCursor,
    Qt,
    QtCore,
    QFrame,
    QIcon,
    QLineEdit,
    QMenu,
    QMessageBox,
    QPainter,
    QPen,
    QPixmap,
    QPushButton,
    QSize,
    QSizePolicy,
    QSpacerItem,
    QStyledItemDelegate,
    QTreeWidgetItem,
    QVBoxLayout,
    QWidget
)


# new backward-incompatible modules
try:
    import ida_dirtree
except ImportError:
    pass

class IdaXlmDialog(QWidget):
    def __init__(self, env_desc):
        super(IdaXlmDialog, self).__init__()

        self.env_desc = env_desc

        self.ui = Ui_PluginDialog(env_desc)
        self.ui.setupUi(self)

        # Set event handlers.
        self.ui.taskView.doubleClicked.connect(self.treeDoubleClick)
        self.ui.promptWidget.tabContext._tool._cwContextTemplate._select.itemRemoved.connect(self.removeContextData)
        self.ui.promptWidget.tabPrompt._tool._cwPromptTemplate._select.itemRemoved.connect(self.removePromptData)
        self.ui.ScriptsHeader.clicked.connect(self.swapLayout)
        self.ui.taskView.pickUpdate.connect(self.updatePromptPick)
        self.ui.wProviderTool.svcUpdate.connect(self.updatePromptServices)

        self.is_sidebar_on_left = True

    def updatePromptPick(self, pick):
        self.ui.promptWidget.updateUi(pick)

    def updatePromptServices(self, services):
        self.ui.promptWidget.updateSvc(services)

    def swapLayout(self, reset=True):
        layout = self.ui.DialogSplitter

        layout_sizes = None
        if reset:
            layout_width = layout.width()
            l_size = int(layout_width * 0.3)
            r_size = int(layout_width * 0.7)
            layout_sizes = [l_size, r_size] if self.is_sidebar_on_left else [r_size, l_size]
        else:
            layout_sizes = layout.sizes()
            layout_sizes = layout_sizes[::-1]

        self.ui.SidebarFrame.setParent(None)
        self.ui.stackedWidget.setParent(None)

        if self.is_sidebar_on_left:
            layout.insertWidget(0, self.ui.stackedWidget)
            layout.insertWidget(1, self.ui.SidebarFrame)
        else:
            layout.insertWidget(0, self.ui.SidebarFrame)
            layout.insertWidget(1, self.ui.stackedWidget)

        layout.setSizes(layout_sizes)
        self.is_sidebar_on_left = not self.is_sidebar_on_left


    def replaceContextData(self, org, key, val):
        self.ctx_data.pop(org)
        self.ctx_data[key] = val
        plg_utils.set_json('data/context.json', self.ctx_data)

    def insertContextData(self, key, val):
        self.ctx_data[key] = val
        plg_utils.set_json('data/context.json', self.ctx_data)

    def removeContextData(self, text):
        self.ctx_data.pop(text)
        plg_utils.set_json('data/context.json', self.ctx_data)

    def replacePromptData(self, org, key, val):
        self.qry_data.pop(org)
        self.qry_data[key] = val
        plg_utils.set_json('data/prompt.json', self.qry_data)

    def insertPromptData(self, key, val):
        self.qry_data[key] = val
        plg_utils.set_json('data/prompt.json', self.qry_data)

    def removePromptData(self, text):
        self.qry_data.pop(text)
        plg_utils.set_json('data/prompt.json', self.qry_data)

    def treeDoubleClick(self, index):
        if not index.isValid():
            return None
        addr_index = index.sibling(index.row(), 1)
        cell_data = addr_index.data()
        if cell_data and cell_data.startswith('0x'):
            idaapi.jumpto(plg_utils.from_hex(cell_data))

    # def renderContextData(self):
    #     pass

    def compileCtxPrompt(self):
        pass

    def saveSession(self):
        with open("{}_idaxlm.json".format(self.env_desc.ida_module), 'w') as f:
            json.dump(self.job_data, f, indent=4)

    def loadSession(self):
        with open("{}_idaxlm.json".format(self.env_desc.ida_module), 'r') as f:
            self.job_data = json.load(f)
