# -*- coding: utf-8 -*-

from shims.qt_shims import (
    QColor,
    QCursor,
    QFrame,
    QHBoxLayout,
    QIcon,
    QMetaObject,
    QPushButton,
    QSize,
    QSizePolicy,
    QSpacerItem,
    QSplitter,
    QStackedWidget,
    Qt,
    QVBoxLayout,
    QWidget
)
from utils.qt_utils import i18n

from ui.qt_widgets import (
    PromptWidget,
    FilterInputGroup,
    ProgressIndicator,
    ProviderTool,
    TaskView
)

class Ui_PluginDialog(object):
    def __init__(self, env_desc):
        self.env_desc = env_desc

    def setupUi(self, PluginDialog):
        if not PluginDialog.objectName():
            PluginDialog.setObjectName(u"PluginDialog")
        PluginDialog.resize(1024, 600)
        icon = QIcon()
        icon.addFile(u":/idaxlm/icon_64.png", QSize(), QIcon.Normal, QIcon.Off)
        PluginDialog.setWindowIcon(icon)
        self.vlPluginDialog = QVBoxLayout(PluginDialog)
        self.vlPluginDialog.setObjectName(u"vlPluginDialog")
        self.DialogSplitter = QSplitter(PluginDialog)
        self.DialogSplitter.setObjectName(u"DialogSplitter")
        self.DialogSplitter.setOrientation(Qt.Horizontal)
        self.DialogSplitter.setChildrenCollapsible(False)
        self.SidebarFrame = QFrame(self.DialogSplitter)
        self.DialogSplitter.setSizes([560, 200])
        self.SidebarFrame.setObjectName(u"SidebarFrame")
        self.SidebarLayout = QVBoxLayout(self.SidebarFrame)
        self.SidebarLayout.setSpacing(0)
        self.SidebarLayout.setObjectName(u"SidebarLayout")
        self.SidebarLayout.setContentsMargins(0, 0, 0, 0)

        self.ScriptsLayout = QVBoxLayout()
        self.ScriptsLayout.setSpacing(0)
        self.ScriptsLayout.setObjectName(u"ScriptsLayout")
        self.ScriptsHeader = QPushButton(self.SidebarFrame)
        self.ScriptsHeader.setObjectName(u"ScriptsHeader")
        self.ScriptsHeader.setMinimumSize(QSize(200, 30))
        self.ScriptsHeader.setCursor(QCursor(Qt.PointingHandCursor))
        self.ScriptsHeader.setProperty("class", "head")
        self.ScriptsLayout.addWidget(self.ScriptsHeader)

        self.taskView = TaskView(self.SidebarFrame)
        self.ScriptsLayout.addWidget(self.taskView)
        self.SidebarLayout.addLayout(self.ScriptsLayout)
        self.sScriptsBottom = QSpacerItem(20, 10, QSizePolicy.Minimum, QSizePolicy.Fixed)
        self.SidebarLayout.addItem(self.sScriptsBottom)

        self.wProviderTool = ProviderTool(u"ProviderTool", self.env_desc, PluginDialog)
        self.SidebarLayout.addWidget(self.wProviderTool)
        self.DialogSplitter.addWidget(self.SidebarFrame)

        self.stackedWidget = QStackedWidget(self.DialogSplitter)
        self.MainFrame = QFrame(self.stackedWidget)
        self.MainFrame.setObjectName(u"MainFrame")
        self.MainLayout = QVBoxLayout(self.MainFrame)
        self.MainLayout.setSpacing(0)
        self.MainLayout.setObjectName(u"MainLayout")
        self.MainLayout.setContentsMargins(5, 0, 0, 0)
        self.wProgressBar = ProgressIndicator(self.MainFrame)
        self.wProgressBar.setObjectName(u"wProgressBar")
        self.wProgressBar.setMinimumSize(QSize(0, 5))
        self.wProgressBar.setMaximumSize(QSize(16777215, 5))

        self.MainLayout.addWidget(self.wProgressBar)

        self.wResultsView = QWidget(self.MainFrame)
        self.wResultsView.setObjectName(u"wResultsView")
        self.hlResultsView = QHBoxLayout(self.wResultsView)
        self.hlResultsView.setObjectName(u"hlResultsView")
        self.hlResultsView.setContentsMargins(0, 0, 0, 0)

        self.promptWidget = PromptWidget(PluginDialog, self.env_desc)
        self.hlResultsView.addWidget(self.promptWidget)
        self.MainLayout.addWidget(self.wResultsView)

        self.MainLayout.setStretch(1, 8)
        self.MainLayout.setStretch(2, 1)
        self.MainLayout.setStretch(4, 1)
        self.stackedWidget.addWidget(self.MainFrame)

        self.vlPluginDialog.addWidget(self.DialogSplitter)

        self.DialogSplitter.addWidget(self.stackedWidget)

        self.retranslateUi(PluginDialog)

        QMetaObject.connectSlotsByName(PluginDialog)

    def retranslateUi(self, PluginDialog):
        PluginDialog.setWindowTitle(i18n("IDAxLM v0.9"))
        self.ScriptsHeader.setText(i18n("Tasks"))
