import idaapi
import idautils
#
import sip

from shims.qt_shims import (
    QCoreApplication,
    QSize,
    QtWidgets
)


def i18n(text, context="PluginDialog"):
    return QCoreApplication.translate(context, text)

def set_fixed_size(wgt, w, h):
    wgt.setMinimumSize(QSize(w, h))
    wgt.setMaximumSize(QSize(w, h))

def get_ptr_wgt(wgt_ptr):
    return sip.wrapinstance(int(wgt_ptr), QtWidgets.QWidget)

def get_parent_wgts(p_wgt, c_wgts):
    for wgt in c_wgts:
        yield p_wgt.findChild(wgt)

def getTopParent(item):
    while item.parent():
        item = item.parent()
    return item
