@echo off

rem #########################################################
rem  IdaPython Plugin Setup Script
rem  Copyright (c) 2024
rem  Sergejs 'HRLM' Harlamovs <harlamism@gmail.com>
rem  Licensed under the MIT License. All rights reserved.
rem #########################################################

setlocal enabledelayedexpansion

:: set "plugin_name="

set "path_sd=%SystemDrive%"
set "path_pf=%ProgramFiles%"
set "path_pf86=%ProgramFiles(x86)%"

set "search_pat=IDC "
set "artifact_py=Python"

set "plugin_paths[0]="
set "python_paths[0]="
set /a path_idx=1
set /a dist_idx=1
set "is_new_plugin=0"
set "is_debug=true"

set "current_dir=%~dp0"
set "current_dir=%current_dir:~0,-1%"
for %%a in ("%current_dir%") do set "parent_dir=%%~nxa"
call :LogDebug Distributive Name: %parent_dir%
call :ToLowerCase "%parent_dir%"
set "plugin_dir=%current_dir%\%plugin_name%"

rem Verify the accessibility of plugin files
if not exist "!plugin_dir!" (
    echo Folder '%plugin_name%' does not exist in the current directory.
    goto :eof
)
set "file_to_manage=%plugin_dir%\%plugin_name%.py"
if not exist "!file_to_manage!" (
    echo File '%plugin_name%.py' does not exist in the '%plugin_name%' folder.
    goto :eof
)

rem Identify directories where the plugin can be installed
for /d %%F in ("%path_pf%\%search_pat%*") do (
    call :FilterAndAdd "%%~fF"
)
for /d %%F in ("%path_pf86%\%search_pat%*") do (
    call :FilterAndAdd "%%~fF"
)



rem Identify directories where the Python can be installed
for /d %%F in ("%path_sd%\%artifact_py%*") do (
    call :FilterAndAddP "%%~fF"
)
for /d %%F in ("%path_pf%\%artifact_py%*") do (
    call :FilterAndAddP "%%~fF"
)
for /d %%F in ("%path_pf86%\%artifact_py%*") do (
    call :FilterAndAddP "%%~fF"
)

rem Display the setup menu
:MENU
echo:
type banner.txt
echo:
echo:
set /a total_paths=path_idx-1

if "%total_paths%"=="0" (
    echo "IDA Pro" is not installed or is in a non-standard location.
    set /P selected_path=Enter the path to "IDA Pro": ^(N - exit^): 

    rem Add \plugins suffix to the selected path
    set "selected_path=!selected_path!\plugins"


) else (

set "extra_path=%USERPROFILE%\AppData\Roaming\Hex-Rays\IDA Pro\plugins"
if exist "!extra_path!" (
    set "plugin_paths[!path_idx!]=!extra_path!"
    set /a path_idx+=1
)
for /L %%i in (1,1,%total_paths%) do (
    echo %%i - !plugin_paths[%%i]!
)
echo:
SET /P path_choice=Select the installation path ^(0 - exit^): 

if "%path_choice%"=="0" goto :eof
if defined plugin_paths[%path_choice%] (
    set "selected_path=!plugin_paths[%path_choice%]!"


) else (
    echo Invalid path selection. Try again.
    goto MENU
)

)


    call :CheckNewPluginFormat "!selected_path!"

	rem Could not determine plugin format by path
	if "!is_new_plugin!"=="-1" (
        goto FORMAT_MENU
	)

    rem Proceed with action menu
    goto ACTION_MENU




:FORMAT_MENU
echo:
echo 1 - Old plugin format
echo 2 - New plugin format
echo:
SET /P format_choice=Choose a format: 

if "%format_choice%"=="1" (
    set "is_new_plugin=0
) else if "%format_choice%"=="2" (
    set "is_new_plugin=1
)

rem Display the action menu
:ACTION_MENU
echo:
echo 1 - Install files
echo 2 - Install symlinks
echo 3 - Remove plugin
echo:
SET /P action_choice=Choose an action: 

if "%action_choice%"=="1" (
    call :REMOVE_ACTION "hide"
    call :COPY_ACTION
	goto PROMPT
) else if "%action_choice%"=="2" (
    call :REMOVE_ACTION "hide"
    call SYMLINK_ACTION
) else if "%action_choice%"=="3" (
    call :REMOVE_ACTION "show"
) else (
    echo Invalid action selection. Try again.
    goto ACTION_MENU
)

rem Remove the plugin folder or symlink from the selected path
:REMOVE_ACTION
set "is_output=%~1"
call :ExecuteCommand rmdir /S /Q "!selected_path!\!plugin_name!"
if %ERRORLEVEL% equ 0 (
    if "%is_output%"=="show" (
        echo The plugin removed successfully.
    )
    rem Perform extra action for old plugin
    if "!is_new_plugin!"=="0" (
        call :ExecuteCommand del /Q "!selected_path!\%plugin_name%.py"
        if %ERRORLEVEL% neq 0 (
            echo Failed to remove '%plugin_name%.py'.
        )
    )
) else (
    echo Failed to remove the plugin.
)
goto :eof

rem Copy the plugin folder to the selected path
:COPY_ACTION
call :ExecuteCommand xcopy /E /I /Y "!plugin_dir!" "!selected_path!\%plugin_name%"
if %ERRORLEVEL% equ 0 (
    echo The plugin installed successfully!

    rem Extra action if the version flag is true (version < 9.0)
    if "!is_new_plugin!"=="0" (
        call :ExecuteCommand  move /Y "!selected_path!\%plugin_name%\%plugin_name%.py" "!selected_path!\%plugin_name%.py"
        if %ERRORLEVEL% neq 0 (
            echo Failed to move '%plugin_name%.py'.
        )
    )
) else (
    echo Failed to copy the folder.
)
goto :eof

rem Create a symbolic link to the plugin folder in the selected path
:SYMLINK_ACTION
call :ExecuteCommand mklink /D "!selected_path!\%plugin_name%" "!plugin_dir!"
if %ERRORLEVEL% equ 0 (
    echo Symlinks created successfully!

    rem Extra action if the version flag is true (version < 9.0)
    if "!is_new_plugin!"=="0" (
        call :ExecuteCommand mklink "!selected_path!\%plugin_name%.py" "!plugin_dir!\%plugin_name%.py"
        if %ERRORLEVEL% neq 0 (
            echo Failed to create symlink for '%plugin_name%.py'.
        )
    )
) else (
    echo Failed to create the symlink.
)
goto :eof

:PROMPT
echo:

set /a total_dists=dist_idx-1
for /L %%i in (1,1,%total_dists%) do (
    echo %%i - !python_paths[%%i]!
)


SET /P AREYOUSURE=Should the dependencies be installed (Y/N)? 
IF /I "%AREYOUSURE%" NEQ "Y" (
    python -m pip install -r requirements.txt
)

goto :eof

:FilterAndAdd
set "folder_path=%~1\plugins"
set "folder_name=%~nx1"

rem Use delayed expansion for correct variable expansion
if /i not "!folder_name:~0,8!"=="IDA Free" if /i not "!folder_name:~0,8!"=="IDA Home" (
    set "plugin_paths[!path_idx!]=%folder_path%"
    set /a path_idx+=1
)
goto :eof

:FilterAndAddP
set "py_path=%~1"

rem Use delayed expansion for correct variable expansion
    set "python_paths[!dist_idx!]=%py_path%"
    set /a dist_idx+=1

goto :eof

:CheckNewPluginFormat
    set "selected_path=%~1"

    for %%A in ("%selected_path%") do (
        set "path_without_plugins=%%~dpA"
    )
    rem Trim any trailing backslash
    set "path_without_plugins=%path_without_plugins:~0,-1%"

    rem Get the last 4 characters (e.g., 8.4, 9.0, 10.0)
    set "version=%path_without_plugins:~-4%"

    rem Trim leading spaces from version
    set "version_trimmed="
    for /f "tokens=* delims= " %%a in ("%version%") do set "version_trimmed=%%a"

    rem Set the flag based on the version
	if "%version_trimmed%"=="Pro" (
        set "is_new_plugin=-1"
	) else (
        if "%version_trimmed%" geq "9.0" (
            set "is_new_plugin=1"
        ) else (
            set "is_new_plugin=0"
        )
	)
goto :eof

:toLowerCase
    set "_STRING=%~1"

    set "_UCASE=ABCDEFGHIJKLMNOPQRSTUVWXYZ"
    set "_LCASE=abcdefghijklmnopqrstuvwxyz"

    for /l %%a in (0,1,25) do (
        call set "_FROM=%%_UCASE:~%%a,1%%"
        call set "_TO=%%_LCASE:~%%a,1%%"
        call set "_STRING=%%_STRING:!_FROM!=!_TO!%%"
    )

    REM Return the modified string
    set "plugin_name=%_STRING%"
    goto :eof

:ExecuteCommand
set "cmd=%*"
if "%is_debug%"=="true" (
    echo "!cmd!"
    !cmd!
) else (
    !cmd! 1>nul 2>nul
)
goto :eof

:: Print debug messages
:LogDebug
if "%is_debug%"=="1" (
    echo [DEBUG]: %*
)
goto :eof

endlocal
pause
